set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3112',
      '3',
      49,
      NULL,
      '3434240',
      51.853649,
      2,
      1,
      1,
      '010102',
      4.054285,
      ' 6- 3-1988',
      17.833762,
      42.528596,
      NULL,
      NULL,
      1.558483,
      3.095914,
      NULL,
      NULL,
      1,
      1,
      3.116087,
      1,
      1,
      1.250100,
      0.445100,
      0.402733,
      1,
      3,
      1,
      NULL,
      1.793212,
      1,
      0.537009,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1.703948,
      3.552263,
      1,
      NULL,
      NULL,
      1.001355,
      NULL,
      NULL,
      2,
      1,
      1.371775,
      0.457268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040976,
      0,
      1.894646,
      0.145348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.855059,
      NULL,
      0.089157,
      5,
      0,
      1.828156,
      NULL,
      0,
      0.604956,
      1.604411,
      3.439268,
      1.334654,
      0,
      0.210698,
      0,
      NULL,
      NULL,
      1,
      1.105345,
      3.991429,
      NULL,
      7,
      NULL,
      2.484803,
      0.465037,
      3,
      NULL,
      3.402056,
      5,
      6.599345,
      NULL,
      NULL,
      5.622169,
      7.516461,
      NULL,
      3.421545,
      0,
      8,
      5,
      4,
      10,
      9,
      4,
      0.299203,
      NULL,
      1.024910,
      NULL,
      NULL,
      4.815985,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.648586,
      1,
      2,
      0,
      NULL,
      0.951792,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719910,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440722,
      0,
      0,
      1.971905,
      3,
      3.666738,
      1.454606,
      NULL,
      0.237094,
      3.926295,
      1.884822,
      1.087747,
      NULL,
      1,
      0.419084,
      1.054531,
      1,
      NULL,
      1.773362,
      0.504408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '41233',
      '',
      '',
      0.343572,
      '',
      NULL,
      NULL,
      NULL,
      '0333',
      '',
      '',
      2,
      0.566538,
      1.288869,
      NULL,
      NULL,
      1,
      3,
      0.642453,
      0.518067);
commit;
end;
/


