set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217527';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      '3',
      NULL,
      NULL,
      '0013401',
      9.556665,
      2,
      2,
      2,
      '040120',
      1.295107,
      ' 9-13-1983',
      NULL,
      NULL,
      1.233006,
      NULL,
      3,
      1.189135,
      3,
      0.340768,
      0,
      1,
      1.350891,
      1.448261,
      NULL,
      NULL,
      4,
      1,
      0,
      0.346025,
      0.925583,
      NULL,
      1,
      0,
      0.176915,
      0.867002,
      0,
      1.039151,
      6.434890,
      1,
      2,
      NULL,
      0.832112,
      NULL,
      NULL,
      NULL,
      1.590460,
      NULL,
      NULL,
      7,
      1.111844,
      0.850948,
      0,
      0,
      NULL,
      3,
      0,
      1.816682,
      1.592536,
      NULL,
      3.587417,
      0.134019,
      NULL,
      2,
      2.136427,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.406695,
      1.159748,
      NULL,
      1.782383,
      5.325712,
      1.019272,
      1.849389,
      0.228370,
      1,
      0,
      NULL,
      1,
      1.419812,
      NULL,
      NULL,
      0,
      0.887690,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.870341,
      1.129048,
      1.707941,
      NULL,
      6,
      4.722544,
      5.835034,
      3.047965,
      0.032013,
      NULL,
      6,
      1.274180,
      7,
      6.292745,
      NULL,
      2,
      NULL,
      1,
      3.220044,
      6.024939,
      4,
      5.379227,
      5,
      4.448408,
      NULL,
      1.507469,
      0.774828,
      0.064175,
      0.619127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.486925,
      0,
      2,
      1,
      1,
      NULL,
      1.421295,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.620170,
      1.764557,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.971405,
      3.324019,
      1,
      0,
      0.826698,
      NULL,
      NULL,
      NULL,
      1,
      1.354537,
      0.414976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.247285,
      3.196281,
      NULL,
      1,
      1.669382,
      1,
      0,
      0,
      3.100901,
      3.885479,
      0.527615,
      0,
      0,
      0.436036,
      1,
      NULL,
      NULL,
      0.020858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '2124',
      '10343',
      '24444',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3.532484,
      5,
      3,
      3,
      2,
      1.340660,
      3,
      NULL,
      0.439693);
commit;
end;
/


