set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204365';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '222',
      NULL,
      8.705350,
      NULL,
      '1240023',
      5,
      5,
      NULL,
      2,
      '440444',
      4,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.692733,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0.252439,
      NULL,
      0.529150,
      1,
      NULL,
      0.571332,
      0.066439,
      NULL,
      0.013798,
      0.818088,
      0.909464,
      0.472688,
      1,
      1,
      5.116296,
      0,
      2,
      1.511390,
      0,
      1,
      NULL,
      NULL,
      0.356322,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.853781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.607127,
      3.285430,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.170286,
      NULL,
      NULL,
      1,
      0.232223,
      NULL,
      NULL,
      1,
      1.986773,
      NULL,
      0.542052,
      1,
      0.881825,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0.546215,
      0,
      0,
      1,
      0.838068,
      0,
      NULL,
      0.839484,
      NULL,
      1.662720,
      0.331889,
      1,
      NULL,
      NULL,
      NULL,
      0.934554,
      0.663332,
      NULL,
      0,
      4.798236,
      1,
      2.612527,
      7,
      1.256769,
      NULL,
      0,
      0,
      0,
      3.879100,
      1,
      1,
      9.908114,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.119508,
      0,
      0,
      1,
      1,
      0,
      0.433067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.382354,
      0,
      2,
      2.120906,
      2,
      3,
      1.727295,
      1,
      1.033971,
      1.668871,
      NULL,
      1.530244,
      NULL,
      NULL,
      NULL,
      1.895511,
      0,
      NULL,
      6.746523,
      0.804119,
      1,
      5.672606,
      1,
      NULL,
      NULL,
      NULL,
      4.529108,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.891017,
      3,
      1.484708,
      NULL,
      1.914776,
      NULL,
      NULL,
      0.095510,
      NULL,
      1.792165,
      NULL,
      0.783042,
      1.195995,
      1.858339,
      0.135116,
      1.951126,
      1.742210,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.467828,
      '0102',
      '',
      NULL,
      0,
      '43343',
      NULL,
      '',
      NULL,
      NULL,
      '0134',
      '1344',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


