set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204365';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '234',
      '11214321',
      27.338842,
      21.256724,
      '3022100',
      17,
      4,
      0,
      NULL,
      '431201',
      4,
      ' 3-24-1991',
      9,
      19,
      0,
      NULL,
      0,
      NULL,
      0,
      0.620449,
      NULL,
      0.015219,
      0,
      0.927481,
      1.570214,
      NULL,
      1.461760,
      NULL,
      0.278293,
      NULL,
      1.031202,
      0.711685,
      NULL,
      1,
      1,
      NULL,
      0,
      0.030890,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.296456,
      1.536833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.230178,
      0.788701,
      3.553495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470302,
      NULL,
      1.020801,
      0,
      0,
      1,
      0.128714,
      1,
      3.681000,
      2.906776,
      0,
      1,
      3,
      1.159676,
      1,
      NULL,
      0,
      0.702485,
      NULL,
      0.511356,
      0,
      0,
      NULL,
      1.426489,
      NULL,
      0,
      1,
      2,
      1.435932,
      0,
      0,
      0,
      0,
      4,
      1.802355,
      0.696732,
      7,
      7,
      1.451915,
      7.486223,
      4,
      4,
      6.281594,
      1.510733,
      0,
      0.133175,
      0,
      1.895895,
      NULL,
      NULL,
      7,
      0.511383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476950,
      1.475422,
      0,
      1,
      0,
      1.800099,
      0.188483,
      1.935464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      3.488737,
      2.976147,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      1,
      1,
      0.250508,
      NULL,
      NULL,
      NULL,
      1,
      1.040485,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.447023,
      0.115014,
      0,
      1,
      1,
      1.481071,
      1,
      0.799696,
      0.946940,
      1,
      0,
      1.159392,
      1,
      0.511573,
      0.762100,
      0.640397,
      0.245072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '40002',
      NULL,
      '',
      1,
      '',
      '',
      '',
      4,
      '3241',
      '1114',
      '31401',
      1,
      4,
      2.357685,
      2.995915,
      2,
      NULL,
      3,
      NULL,
      NULL);
commit;
end;
/


