set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '3320234',
      15,
      2,
      NULL,
      1,
      '422331',
      NULL,
      ' 1-21-1991',
      NULL,
      NULL,
      1.304746,
      NULL,
      3,
      0.623724,
      1,
      0.226517,
      1.708329,
      NULL,
      0.239353,
      0.646004,
      NULL,
      0,
      3.370200,
      0,
      NULL,
      0,
      0.593132,
      NULL,
      4,
      4.110532,
      1,
      0.287229,
      6,
      7,
      1,
      NULL,
      0.743803,
      0,
      1,
      1.771093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276562,
      1.158365,
      1.020645,
      0,
      2.862431,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3.988555,
      2.124712,
      1.935271,
      0,
      0.707196,
      NULL,
      3,
      3,
      0.971093,
      0,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.418005,
      NULL,
      0.257669,
      0.402080,
      0,
      1.740749,
      1,
      0,
      0,
      1,
      1.728240,
      NULL,
      2.631000,
      1,
      1.515652,
      1.115762,
      1,
      0,
      NULL,
      1.517839,
      4,
      1.833017,
      2.962835,
      5,
      0,
      NULL,
      1.053786,
      1,
      NULL,
      0.790487,
      5.551111,
      NULL,
      1,
      4.617050,
      0.974107,
      0.948648,
      7.619207,
      3,
      4,
      2,
      3.005040,
      5.384148,
      8.617368,
      2,
      NULL,
      3.239342,
      NULL,
      2,
      0,
      1.468099,
      8.967162,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607671,
      0.083525,
      NULL,
      1,
      1.394647,
      0.172531,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.812828,
      1.509954,
      0,
      NULL,
      NULL,
      NULL,
      0.053538,
      NULL,
      0.075125,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.169164,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501411,
      3,
      2.885841,
      1.849215,
      2.148810,
      3.298041,
      NULL,
      0,
      1.187168,
      0,
      0.842347,
      NULL,
      1.900466,
      0.182352,
      0,
      1.220647,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.477657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '21113',
      '',
      '',
      2.810459,
      '00424',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


