set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '3430020',
      47,
      6,
      0.569117,
      NULL,
      '414020',
      0,
      ' 1-29-1991',
      40,
      NULL,
      0,
      NULL,
      1.072076,
      1.564853,
      1,
      1.059761,
      NULL,
      0.010856,
      1,
      0.733672,
      0,
      0,
      1.097368,
      0.633408,
      1.103252,
      NULL,
      1.655278,
      NULL,
      NULL,
      NULL,
      1,
      0.101201,
      1,
      1,
      0.339452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.260288,
      NULL,
      2.896084,
      1,
      1,
      1.614555,
      1,
      1.863346,
      3,
      0,
      0,
      0,
      0.252637,
      3.279483,
      1,
      NULL,
      1,
      1.429496,
      0,
      0.913913,
      3.800355,
      6,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.698343,
      NULL,
      NULL,
      NULL,
      0.776729,
      NULL,
      1.610331,
      1.722697,
      1.279234,
      0,
      0.228001,
      0.397508,
      1.224334,
      0,
      0.297010,
      1,
      1,
      1,
      1,
      NULL,
      1.003589,
      2.861110,
      2.876018,
      3.151511,
      NULL,
      NULL,
      0.036516,
      0.492409,
      NULL,
      3.929466,
      1,
      1,
      2.760291,
      0,
      4,
      0,
      4,
      7,
      5,
      1,
      9.220034,
      8.159662,
      3.296722,
      1.030090,
      0.641525,
      5,
      0,
      2,
      NULL,
      NULL,
      1.465012,
      5.175653,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905664,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.174247,
      NULL,
      3,
      1.331785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.530154,
      NULL,
      6.041665,
      6.055167,
      2.379562,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.596246,
      1.910718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582641,
      0,
      1,
      1,
      0,
      1.399983,
      2.720230,
      1.312348,
      0.384647,
      NULL,
      2.976582,
      1.046363,
      0,
      0.641595,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.125367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '01431',
      '',
      '',
      2,
      '20444',
      '',
      '',
      1.451318,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


