set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '213',
      '42',
      32,
      0,
      '3432323',
      11.366852,
      4,
      3,
      2,
      '104022',
      3.315139,
      ' 9- 2-1986',
      31.474540,
      15.102799,
      NULL,
      NULL,
      3,
      NULL,
      2.265144,
      1,
      1.334952,
      0.091294,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1.479768,
      NULL,
      1.989197,
      3.646799,
      4,
      2,
      0,
      0,
      NULL,
      1.474039,
      5,
      0,
      3.873996,
      0,
      1,
      0.400993,
      NULL,
      NULL,
      1.036400,
      NULL,
      NULL,
      NULL,
      0,
      5.644533,
      3,
      1.210084,
      NULL,
      0,
      NULL,
      0.396904,
      3,
      1.257674,
      1.726044,
      2.731037,
      1,
      2,
      3,
      1,
      1.971134,
      0,
      NULL,
      0.041877,
      0.908175,
      2,
      1,
      0,
      0.894519,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.181789,
      0.888531,
      7.945644,
      NULL,
      5,
      1.520747,
      NULL,
      0.204487,
      1.278760,
      0,
      NULL,
      1,
      0.154686,
      1.493800,
      1.530661,
      1.977129,
      1,
      NULL,
      1,
      NULL,
      1.818322,
      3,
      0.992562,
      4,
      2.452563,
      1.080835,
      0,
      0,
      4.144986,
      1.144255,
      0,
      2,
      5,
      3.328940,
      NULL,
      0.785272,
      NULL,
      5.994674,
      NULL,
      9.103269,
      3.342637,
      6,
      8,
      7,
      NULL,
      0.641989,
      9.954007,
      4.637308,
      NULL,
      1.625262,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1.436520,
      0,
      1.929776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.509470,
      NULL,
      1.488131,
      1,
      1,
      1.767369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.681169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.529831,
      3,
      0.128313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.682758,
      0.189982,
      0.301451,
      3,
      1,
      0.946487,
      NULL,
      2,
      0,
      0,
      0.729230,
      0.931966,
      0.927948,
      1.407248,
      0.176925,
      0.347662,
      NULL,
      1.873392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780611,
      '32414',
      '',
      '',
      3.015272,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.284983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


