set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '341',
      '03011304',
      NULL,
      64,
      '3201304',
      31,
      2,
      1,
      3,
      '122210',
      4,
      ' 3-19-1995',
      NULL,
      NULL,
      0.414193,
      NULL,
      2,
      1,
      1,
      1,
      0.685677,
      2,
      1.562741,
      1,
      3.817453,
      0,
      1.005536,
      0.023387,
      0.581928,
      1.390763,
      NULL,
      2,
      0.648479,
      NULL,
      1.094736,
      1,
      NULL,
      0,
      0.265909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.036268,
      1,
      0,
      1,
      1.394449,
      0,
      3,
      NULL,
      0,
      NULL,
      2,
      3.330568,
      2.617673,
      NULL,
      NULL,
      1,
      0.834416,
      0,
      0,
      NULL,
      0,
      0.746433,
      5,
      0,
      0,
      0.079402,
      0.233935,
      NULL,
      NULL,
      1.254196,
      NULL,
      NULL,
      0.397377,
      1.675867,
      0,
      0,
      0.482247,
      1.558930,
      NULL,
      NULL,
      1.175749,
      0.909395,
      NULL,
      0.746182,
      0,
      0.106652,
      NULL,
      1.514616,
      1.346062,
      NULL,
      0.928329,
      NULL,
      0,
      NULL,
      1,
      1.287979,
      0.739817,
      1.815450,
      3,
      0.788958,
      1,
      NULL,
      2.847529,
      NULL,
      5,
      NULL,
      6.202201,
      NULL,
      1.664097,
      NULL,
      1,
      4,
      NULL,
      NULL,
      0.029292,
      2.643681,
      1,
      5,
      9.564433,
      7,
      2,
      1,
      0.340399,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.062321,
      0.297449,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776811,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129784,
      1,
      2,
      0.455625,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.062188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      2.247956,
      2,
      2.326567,
      1.802919,
      NULL,
      3,
      1.697169,
      0,
      NULL,
      1,
      1,
      1.363515,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      '',
      3.033961,
      '12232',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      0.394611,
      1.639425,
      NULL,
      NULL,
      NULL,
      0.420603,
      2,
      NULL);
commit;
end;
/


