set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      1.906730,
      3,
      '132324',
      NULL,
      NULL,
      51,
      2.420828,
      0.825153,
      NULL,
      0,
      0.198473,
      3.659034,
      NULL,
      1.240760,
      1,
      1.342452,
      0.941083,
      1.636294,
      0.435763,
      1.336078,
      NULL,
      NULL,
      1.522867,
      0,
      3.763472,
      1.279031,
      0,
      1,
      1.937636,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.953065,
      1,
      NULL,
      0.213025,
      0,
      1.060059,
      3,
      1.046201,
      NULL,
      0.382698,
      1.097670,
      2,
      0,
      1.465733,
      1,
      2,
      1.177510,
      0.458543,
      1,
      1.160559,
      NULL,
      3.878608,
      0.379626,
      1,
      1,
      0.097338,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.656247,
      5,
      1.758761,
      1,
      1.465720,
      0,
      0.395991,
      0,
      NULL,
      NULL,
      0,
      0.233465,
      0,
      NULL,
      1,
      1,
      NULL,
      0.486798,
      2.571505,
      NULL,
      NULL,
      4,
      0.270884,
      0,
      2.026844,
      NULL,
      NULL,
      NULL,
      NULL,
      4.188090,
      NULL,
      7.880210,
      1,
      0,
      NULL,
      NULL,
      5,
      NULL,
      7.451529,
      0.126371,
      6,
      3.328813,
      5,
      NULL,
      1.477719,
      NULL,
      1.315567,
      NULL,
      3.746291,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.105640,
      0.907441,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018848,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829948,
      NULL,
      NULL,
      NULL,
      1.601439,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.858219,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.089641,
      NULL,
      NULL,
      0.451615,
      3,
      2,
      1.443286,
      2.327086,
      0.894302,
      1,
      NULL,
      NULL,
      NULL,
      1.637859,
      0,
      1.513113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.100111,
      '32224',
      '',
      '',
      2.150588,
      '33341',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1,
      4,
      NULL,
      NULL,
      0,
      2.529813,
      1,
      0,
      2);
commit;
end;
/


