set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2332',
      '33430301',
      29.640138,
      NULL,
      '1033243',
      NULL,
      2,
      0.307118,
      3,
      NULL,
      0,
      ' 2-18-1976',
      14.981641,
      59,
      0.607062,
      NULL,
      NULL,
      1.822765,
      3.496657,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      1.558688,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.062345,
      3.383845,
      5.709069,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.519998,
      NULL,
      NULL,
      0,
      0.368355,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.384858,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101164,
      0,
      1.240013,
      0.259544,
      0,
      1,
      0,
      1.526060,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1.422595,
      NULL,
      1.763930,
      NULL,
      1.444579,
      0,
      4,
      NULL,
      NULL,
      0.456903,
      4.109650,
      6.425950,
      7.207553,
      NULL,
      2,
      0.295572,
      6.052036,
      NULL,
      0,
      7,
      2.837335,
      5.520081,
      9.683233,
      5.302163,
      3.895906,
      8,
      4.403214,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5.327883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.227524,
      0.570132,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.594418,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.587300,
      1.172414,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.622541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043721,
      0.974992,
      NULL,
      0.778846,
      1,
      0.160381,
      0.986503,
      0,
      NULL,
      0,
      0.102816,
      NULL,
      0,
      0.417831,
      NULL,
      1,
      1.074892,
      1.676526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.182178,
      '04444',
      '',
      '',
      0.379304,
      '00312',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4,
      3,
      3,
      2,
      0,
      2,
      3,
      3.073811,
      0);
commit;
end;
/


