set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2313',
      '21104104',
      23,
      NULL,
      '1020124',
      117.912842,
      0,
      3,
      2,
      '231221',
      1,
      NULL,
      NULL,
      41,
      0,
      NULL,
      0.918873,
      1.746353,
      0.711298,
      1.914725,
      NULL,
      0.377605,
      0.504937,
      0.908258,
      1.183355,
      NULL,
      3.508928,
      0,
      0.573477,
      NULL,
      1,
      1,
      3,
      1.848576,
      1,
      0.216159,
      2.606725,
      NULL,
      NULL,
      1,
      0.068093,
      0.857920,
      0.198372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      0,
      3.952455,
      2.619757,
      0.936725,
      1,
      NULL,
      NULL,
      0,
      3.885638,
      1,
      0.145760,
      3,
      1,
      1,
      0,
      1,
      1.233592,
      NULL,
      4.620935,
      NULL,
      0.546131,
      1,
      0,
      3.949277,
      0.777760,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2.590696,
      1.230426,
      0.103252,
      1.395749,
      1.580618,
      1,
      NULL,
      NULL,
      0.026162,
      1.112729,
      1.006723,
      0.011314,
      0,
      0.397420,
      0.782687,
      NULL,
      0.553069,
      2,
      1,
      0.958046,
      NULL,
      1,
      6.042654,
      NULL,
      4.072582,
      2.420052,
      6,
      4.234319,
      3.478415,
      0.443538,
      5,
      0.096424,
      NULL,
      4,
      0,
      NULL,
      NULL,
      10.707632,
      7,
      1.508993,
      NULL,
      1.882622,
      2.696199,
      1,
      3.218411,
      1,
      0.619150,
      0.239634,
      1.764715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.760648,
      NULL,
      NULL,
      1.825754,
      0.618893,
      0,
      0.773778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      3.927301,
      0.620947,
      1.979614,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.439350,
      4.759214,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.126321,
      1.582426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.192737,
      0.984251,
      1.079242,
      NULL,
      0.329935,
      NULL,
      3.807687,
      0,
      3,
      NULL,
      0.900368,
      0,
      0.638911,
      1,
      1.470267,
      0.149345,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '12232',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      0.374266,
      '',
      '',
      '',
      1.679266,
      NULL,
      2.541065,
      5,
      0.367492,
      2.346772,
      0,
      2,
      1.199708);
commit;
end;
/


