set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0134',
      NULL,
      NULL,
      21.251074,
      NULL,
      NULL,
      3,
      3.894753,
      2,
      '231024',
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.635446,
      0.790218,
      1,
      0.132192,
      1,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      1.142798,
      0.580694,
      1.487016,
      7,
      1.730956,
      NULL,
      1.163107,
      4,
      1.793519,
      5.538007,
      0,
      NULL,
      1,
      1.706417,
      1.293412,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.034542,
      1,
      1.111242,
      1,
      1.814459,
      0,
      1,
      1.510735,
      1,
      0.275690,
      0,
      NULL,
      1,
      NULL,
      0.591083,
      2,
      1,
      0.802211,
      1,
      NULL,
      5.414781,
      2.148296,
      1,
      0,
      1,
      0.221789,
      1,
      NULL,
      NULL,
      1.186059,
      NULL,
      NULL,
      0.525760,
      1.166221,
      NULL,
      NULL,
      NULL,
      1,
      1.310712,
      1,
      1.114533,
      0.956212,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1.962510,
      NULL,
      1.845946,
      NULL,
      1.083644,
      6.796307,
      NULL,
      0,
      1.398600,
      0.169640,
      2.538526,
      0.706096,
      0.291806,
      7.532637,
      4.335746,
      0,
      4,
      0.359516,
      0.540374,
      1.795662,
      0.643864,
      NULL,
      7.655562,
      3,
      5,
      NULL,
      NULL,
      7,
      NULL,
      0.311646,
      1,
      5,
      2.861719,
      1,
      1.916531,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869665,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577406,
      NULL,
      NULL,
      NULL,
      NULL,
      2.747493,
      0.444301,
      0.246084,
      0,
      1.307571,
      3.712487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.204841,
      3,
      0.463383,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707747,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.944649,
      1.457790,
      0,
      1.761330,
      0.993082,
      NULL,
      1.415291,
      0,
      NULL,
      3.091655,
      NULL,
      0,
      0,
      NULL,
      1.197760,
      0,
      0,
      0.522494,
      NULL,
      1.174897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '10234',
      '',
      '',
      0,
      '00432',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      4.694256,
      3.031468,
      0,
      1.692951,
      0,
      NULL,
      0,
      NULL,
      3);
commit;
end;
/


