set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2122',
      '33224413',
      16,
      83,
      '0242411',
      79.439941,
      3,
      1,
      2,
      '403031',
      0,
      '10-15-2003',
      39.421618,
      55,
      NULL,
      NULL,
      0,
      0.437425,
      NULL,
      1,
      0.894339,
      NULL,
      1,
      1.289177,
      1,
      1,
      1.123506,
      0,
      NULL,
      1.629286,
      NULL,
      1.872223,
      2,
      0.224340,
      5,
      0,
      3.920179,
      0,
      1,
      0,
      1,
      0,
      2.471360,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.928708,
      1.484631,
      1.554947,
      1.669053,
      0.545270,
      2,
      0,
      0,
      3,
      0,
      3,
      NULL,
      NULL,
      1.469316,
      1,
      1,
      1,
      1,
      2,
      0.773005,
      4,
      7.381239,
      1,
      1,
      1.512227,
      NULL,
      NULL,
      NULL,
      1.394708,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1.698934,
      3,
      1.769506,
      1.480095,
      1,
      NULL,
      0.582537,
      0.282056,
      0.026251,
      0,
      0,
      1.887966,
      1.799879,
      1,
      1.548028,
      1,
      NULL,
      1.687126,
      7.512763,
      NULL,
      1.048737,
      4,
      0,
      3,
      0.678632,
      6.060806,
      NULL,
      7,
      4.592227,
      5,
      3.149356,
      2,
      0.351638,
      NULL,
      1.316728,
      7.131539,
      NULL,
      2.152772,
      10.079375,
      7.560112,
      2.096007,
      3.774022,
      0.128807,
      3,
      5.615409,
      0.290017,
      0,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747252,
      0,
      NULL,
      1,
      1.871678,
      0.191959,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003756,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7,
      0.079371,
      1.860992,
      0,
      1.953487,
      NULL,
      NULL,
      NULL,
      0,
      0.745448,
      1.377301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.757422,
      0.233860,
      1,
      1.584107,
      1,
      NULL,
      2,
      1,
      0.009955,
      0.117890,
      NULL,
      1.273660,
      NULL,
      1,
      0.592026,
      1.246855,
      1.427000,
      NULL,
      NULL,
      0.430546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457900,
      '01241',
      '',
      NULL,
      2,
      '30021',
      NULL,
      '',
      1,
      '',
      '',
      '',
      4,
      1.933375,
      NULL,
      NULL,
      2.283827,
      2,
      1.183447,
      2,
      3);
commit;
end;
/


