set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9823126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '301',
      '13011140',
      5,
      35,
      '2202123',
      0,
      3,
      1.148473,
      1,
      '324233',
      4,
      ' 3-12-1996',
      30,
      29,
      0,
      NULL,
      0.721822,
      3.618643,
      1.104509,
      1.770407,
      0,
      0,
      2.054820,
      1,
      0.661529,
      0,
      NULL,
      NULL,
      0.297670,
      NULL,
      1,
      1.178069,
      9,
      0.213086,
      NULL,
      0,
      1,
      1,
      6.957900,
      0,
      3.587442,
      2,
      3.682287,
      1,
      NULL,
      NULL,
      0,
      0.142490,
      0.282884,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      3.554700,
      0.542692,
      0.063696,
      2,
      1,
      1,
      1.174553,
      0,
      0.165554,
      1.899387,
      NULL,
      NULL,
      0.636476,
      1,
      1.026741,
      3,
      1,
      0,
      1.383096,
      1.578998,
      NULL,
      NULL,
      NULL,
      0,
      0.412332,
      1,
      0.306814,
      0.897057,
      1.543361,
      0,
      1,
      0,
      1,
      1.413932,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1.146615,
      NULL,
      0.099228,
      1,
      NULL,
      NULL,
      1.802407,
      0.320902,
      NULL,
      0.725776,
      NULL,
      NULL,
      0.530057,
      NULL,
      0.694619,
      1,
      1.992642,
      4,
      NULL,
      4,
      0,
      2,
      1,
      NULL,
      5,
      1,
      6,
      2,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.585381,
      NULL,
      0.919306,
      1.079238,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065368,
      0.010108,
      0,
      0,
      0,
      0,
      1.202690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.809674,
      NULL,
      5.655753,
      1.597911,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635275,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804491,
      NULL,
      5.912707,
      6,
      NULL,
      3.126820,
      1,
      NULL,
      NULL,
      2,
      6.602630,
      1.350123,
      1.215190,
      3,
      1.296979,
      8,
      0,
      1.586101,
      0.196505,
      NULL,
      0.804219,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1.725662,
      NULL,
      2.284013,
      1.324240,
      0,
      1,
      NULL,
      1,
      0.106337,
      1.210248,
      0.083796,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.244783,
      1.093884,
      1,
      NULL,
      NULL,
      NULL,
      1.405485,
      2,
      1.387491,
      '03320',
      NULL,
      NULL,
      1.834691,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      2,
      0.173405,
      2.851172,
      NULL);
commit;
end;
/


