set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9823126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      '41243002',
      NULL,
      14.964430,
      '3242012',
      19,
      4,
      0,
      1,
      '241341',
      0.449337,
      ' 7- 5-1996',
      8.331005,
      36.583073,
      0.809448,
      NULL,
      3,
      1.919361,
      1,
      1,
      NULL,
      NULL,
      2,
      1.795803,
      0,
      1.718089,
      3.097654,
      0.762485,
      1.964844,
      NULL,
      0.749091,
      NULL,
      NULL,
      1,
      NULL,
      5.423781,
      0,
      1,
      NULL,
      0,
      0.944102,
      2.763467,
      1,
      1.875693,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1.663654,
      1.257349,
      3,
      0.715330,
      0,
      3,
      NULL,
      3.198156,
      2.498105,
      3,
      NULL,
      3,
      0.869011,
      3,
      0,
      2.914461,
      3,
      NULL,
      1.541706,
      1.928090,
      0.264708,
      1.942432,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.250190,
      1.166913,
      1.356489,
      NULL,
      1.788834,
      0,
      NULL,
      NULL,
      NULL,
      0.921532,
      0.868590,
      1.405522,
      NULL,
      NULL,
      0,
      1.542512,
      1,
      1,
      NULL,
      NULL,
      0,
      4.413162,
      0.371836,
      NULL,
      0.809797,
      1.174488,
      1.386520,
      NULL,
      5,
      NULL,
      0.800392,
      0,
      NULL,
      NULL,
      2.827796,
      1.026930,
      0,
      3,
      7.976148,
      1,
      1.682808,
      4.426856,
      NULL,
      NULL,
      6.782180,
      2.721489,
      2.891255,
      0,
      0,
      1.386445,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149322,
      NULL,
      1,
      1,
      1.762794,
      0.721393,
      1.924215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018443,
      NULL,
      2.211077,
      2.097786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.671759,
      1,
      1.943625,
      NULL,
      NULL,
      NULL,
      0.745010,
      1,
      6.584729,
      4.141913,
      NULL,
      2,
      2.010458,
      NULL,
      NULL,
      NULL,
      NULL,
      3.584087,
      0.251585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.477023,
      0.141002,
      3.827404,
      2.453365,
      1,
      3,
      1.068781,
      0,
      0.002990,
      0.372359,
      0,
      1,
      0.129723,
      0.722262,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.329519,
      '12021',
      '',
      '',
      1,
      '',
      '',
      '',
      0.276416,
      NULL,
      '',
      '',
      5,
      3.208560,
      2.397311,
      0,
      3.244028,
      1,
      NULL,
      0.448910,
      0);
commit;
end;
/


