set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9823126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4100',
      '42133012',
      2,
      73.151533,
      '0010400',
      43,
      0,
      2,
      NULL,
      '314224',
      5,
      ' 3- 7-1979',
      56,
      35.901819,
      NULL,
      NULL,
      1.677006,
      NULL,
      0,
      1,
      0.167391,
      0,
      0.866064,
      2.167698,
      0,
      NULL,
      7,
      1,
      1.617625,
      1,
      0.254484,
      1.359061,
      NULL,
      1,
      5,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.980500,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2.639699,
      0.564686,
      0.281086,
      2.706836,
      2,
      1.796973,
      2,
      3.862687,
      0,
      NULL,
      2.047442,
      2.434269,
      NULL,
      3.280710,
      NULL,
      3.020519,
      0.475509,
      NULL,
      NULL,
      7.578493,
      NULL,
      NULL,
      NULL,
      0.384717,
      NULL,
      NULL,
      0.769371,
      NULL,
      NULL,
      NULL,
      1.886743,
      0.345007,
      0.270468,
      1.834007,
      1.928360,
      1,
      0.460697,
      0,
      1,
      0.050652,
      NULL,
      0,
      NULL,
      1.834883,
      NULL,
      1.511857,
      0.926173,
      0.322818,
      NULL,
      NULL,
      0.126429,
      0,
      0,
      0.297666,
      1,
      1.990266,
      1,
      5,
      NULL,
      5.476816,
      0.123663,
      0,
      2.169707,
      2,
      1.928185,
      4.320748,
      4.987509,
      1,
      0,
      3.067024,
      0,
      1.592139,
      3,
      NULL,
      4.353820,
      0,
      NULL,
      NULL,
      0.340132,
      NULL,
      9,
      0.716167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448313,
      1,
      NULL,
      1.510021,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      1.942682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.602475,
      0,
      NULL,
      NULL,
      NULL,
      3.943328,
      0.159913,
      3.176359,
      1.495762,
      0,
      NULL,
      1.610496,
      NULL,
      NULL,
      NULL,
      0.592958,
      6.528250,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089376,
      0,
      NULL,
      3.139002,
      1.434599,
      0.732892,
      1.064414,
      2,
      1,
      1.489731,
      3,
      0,
      NULL,
      0,
      0.018430,
      NULL,
      0,
      1.675976,
      NULL,
      1.102588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '04410',
      '',
      '',
      1.299050,
      '',
      '',
      '',
      3,
      '3132',
      '',
      '',
      3,
      3,
      3.738235,
      3,
      2.780767,
      0,
      3.220003,
      0,
      0.877514);
commit;
end;
/


