set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9823126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4003',
      '22210334',
      NULL,
      NULL,
      '0312003',
      41.583758,
      NULL,
      2.989405,
      3,
      '244341',
      3.700604,
      NULL,
      3.250112,
      NULL,
      0,
      NULL,
      NULL,
      1.196880,
      0,
      0.802232,
      NULL,
      1.647635,
      0,
      2.297779,
      1.059400,
      NULL,
      7,
      0,
      NULL,
      NULL,
      0.505932,
      0,
      2,
      1,
      1.579739,
      0,
      1.450597,
      0.514560,
      6,
      1,
      NULL,
      1.701185,
      0,
      0.856772,
      NULL,
      NULL,
      0.660477,
      NULL,
      NULL,
      4.903237,
      0.936277,
      1.652866,
      2,
      1,
      0.656850,
      3.615581,
      NULL,
      1.066110,
      2,
      0,
      0.633623,
      1.610457,
      1.984260,
      1.985193,
      NULL,
      2.559059,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1.297770,
      1.419732,
      0,
      0.141317,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.680166,
      0,
      1,
      1.059136,
      0,
      NULL,
      0.920005,
      5.763585,
      NULL,
      0.085340,
      1.213184,
      0.460964,
      3.643816,
      1.774346,
      0.132854,
      0.873635,
      NULL,
      NULL,
      NULL,
      NULL,
      5.047275,
      0,
      0,
      1.771781,
      3,
      NULL,
      3,
      0.362405,
      1,
      2.395780,
      4,
      2,
      NULL,
      5.258187,
      2.753393,
      1,
      1.773333,
      1.058474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1.934628,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266477,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4.812075,
      0.769374,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      2.105978,
      1.179948,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.406905,
      1.287039,
      0,
      NULL,
      1,
      0.171549,
      1.151007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.854746,
      '24444',
      '',
      '',
      1.690927,
      '',
      NULL,
      '',
      2.638053,
      '0244',
      '',
      '',
      3.363386,
      5.744406,
      NULL,
      3,
      0.498484,
      NULL,
      0.539090,
      1.825132,
      2);
commit;
end;
/


