set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303862';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      '40024132',
      17.337324,
      9,
      '3111421',
      135.383571,
      1,
      0.272417,
      3,
      '110011',
      2,
      ' 3-20-1991',
      57.669098,
      48.644907,
      0,
      NULL,
      0.028547,
      0,
      1,
      0,
      NULL,
      0.270696,
      NULL,
      1.004293,
      0,
      1,
      1,
      1,
      0.073076,
      1,
      0.676671,
      1.473537,
      NULL,
      NULL,
      1.235025,
      1,
      0,
      0,
      0.200427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129409,
      0,
      1.799730,
      0,
      1.311028,
      0,
      1.074253,
      0.060801,
      0,
      NULL,
      0,
      0.347552,
      0.874495,
      1,
      0,
      1,
      1.328742,
      0,
      1,
      NULL,
      0,
      4,
      1,
      1,
      2.350803,
      1,
      1,
      0.176450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.554742,
      1.320929,
      1.973356,
      5.463903,
      2,
      NULL,
      3,
      3.776565,
      NULL,
      1,
      3.431044,
      1,
      1,
      2.705942,
      1,
      NULL,
      NULL,
      4.323595,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1.650661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456976,
      NULL,
      0.028027,
      2.213014,
      NULL,
      0.978223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.732781,
      NULL,
      3,
      0.110535,
      1.044064,
      2,
      NULL,
      NULL,
      NULL,
      1.978819,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.114155,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.929615,
      0.190549,
      NULL,
      0.958897,
      1,
      2.264270,
      0.773849,
      1.165308,
      1,
      1.479993,
      NULL,
      3,
      1.118025,
      0.415351,
      1,
      2.762478,
      NULL,
      2.362552,
      1.881356,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      '0022',
      '04314',
      '40310',
      1.256811,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      1,
      1.923750,
      3,
      NULL,
      0.829933,
      2,
      3);
commit;
end;
/


