set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '2241410',
      19,
      NULL,
      NULL,
      2,
      '330320',
      2.224459,
      ' 4- 9-1993',
      0.824770,
      NULL,
      NULL,
      NULL,
      2,
      1.798709,
      1.651523,
      0.686731,
      0.774121,
      0.087613,
      0.485891,
      1,
      NULL,
      0,
      3.629972,
      NULL,
      NULL,
      0.968673,
      2.367439,
      1,
      0.580777,
      1.316496,
      0,
      3,
      2,
      3,
      1.590907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.827567,
      3,
      3.758921,
      1.294377,
      0,
      1.147314,
      1,
      1,
      0.180077,
      1,
      1,
      0,
      1,
      1.604148,
      NULL,
      0.612703,
      1.526403,
      0.132919,
      1.703554,
      0.536681,
      5,
      9,
      0,
      1,
      NULL,
      1.985336,
      NULL,
      NULL,
      0.412887,
      NULL,
      NULL,
      1.008324,
      5,
      4.154040,
      3.539245,
      5,
      NULL,
      1.462907,
      1,
      NULL,
      1.530909,
      1,
      1,
      0.377023,
      1.440738,
      1.361552,
      1,
      1.313945,
      0.382512,
      NULL,
      NULL,
      1,
      7,
      1.909973,
      3.918075,
      NULL,
      1,
      4,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.902648,
      NULL,
      8.914396,
      4,
      NULL,
      8,
      4.757090,
      1.067069,
      NULL,
      4.491132,
      8,
      1.649472,
      2,
      3,
      2.122930,
      1,
      3,
      1.640472,
      NULL,
      5.821816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.368770,
      0.879689,
      NULL,
      0.251014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.661204,
      1.260133,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      0.370858,
      NULL,
      NULL,
      NULL,
      2.687709,
      0.367608,
      NULL,
      1,
      0,
      0,
      1.574931,
      NULL,
      NULL,
      NULL,
      2.261054,
      1.004314,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.719186,
      3,
      NULL,
      1,
      3.519727,
      2,
      0,
      1,
      1.420935,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1.793818,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.750083,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


