set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '0124123',
      33.646623,
      5,
      0,
      NULL,
      '312003',
      2,
      ' 6-28-1994',
      NULL,
      NULL,
      1.968610,
      NULL,
      1.648355,
      1,
      3.345964,
      0,
      NULL,
      3.499515,
      1.033047,
      NULL,
      1,
      0.345370,
      4,
      0,
      3,
      0.573035,
      0.424279,
      0,
      NULL,
      1.023133,
      NULL,
      3.860909,
      1,
      1,
      2.910034,
      1,
      5,
      1,
      1.712169,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.725828,
      NULL,
      0.674802,
      1,
      NULL,
      0.091790,
      NULL,
      1,
      0.815343,
      0,
      1,
      1,
      NULL,
      1.274609,
      0,
      0.113782,
      1.473051,
      0,
      0,
      0.400767,
      0.531305,
      2.336267,
      3,
      0,
      0,
      1,
      0.585178,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.183755,
      0,
      NULL,
      0,
      NULL,
      1.485493,
      NULL,
      1.878106,
      1,
      0.433891,
      3.765774,
      0,
      1.212546,
      0.818081,
      1.585351,
      1,
      1,
      1,
      1.918081,
      NULL,
      0.032491,
      NULL,
      NULL,
      1.228133,
      NULL,
      NULL,
      7,
      1.986310,
      4.016476,
      4,
      0,
      5.336796,
      NULL,
      2,
      6.113194,
      5.674976,
      4.898732,
      4.114217,
      0.904639,
      9,
      8.479716,
      5.958359,
      1.588994,
      6.203997,
      8,
      1,
      5,
      2.435105,
      0,
      0,
      1,
      1.640530,
      1.514296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.085277,
      0,
      0,
      0,
      1.072524,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.734718,
      0,
      1.699195,
      0,
      6,
      0.364779,
      1.616755,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.201565,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870463,
      1.729340,
      2,
      3.358962,
      0,
      1,
      0,
      1.825671,
      1.242599,
      NULL,
      3.169850,
      1.400920,
      0,
      NULL,
      1.015053,
      1.585312,
      1.684105,
      1,
      0,
      0.516748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '23231',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


