set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '310',
      '10',
      17,
      25.612913,
      '2221434',
      49.748421,
      6,
      3,
      NULL,
      '304224',
      2,
      ' 8-29-1989',
      10,
      38.397973,
      1,
      NULL,
      3,
      0.014248,
      2.853936,
      NULL,
      1.919982,
      0,
      NULL,
      NULL,
      0.617043,
      1,
      3.216264,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      0.112553,
      1,
      0,
      1.544632,
      1.705620,
      2,
      0,
      1.227927,
      0.449673,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.102934,
      2.692474,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641850,
      1.211255,
      2.240297,
      NULL,
      1,
      0,
      NULL,
      1.869325,
      NULL,
      NULL,
      0.512660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146803,
      0.118129,
      NULL,
      0,
      0.559057,
      1.324492,
      1.880399,
      NULL,
      1.842747,
      1,
      0.992318,
      1,
      1,
      NULL,
      0,
      NULL,
      0.305393,
      4.759205,
      1.507977,
      0.697653,
      4.827699,
      0,
      6,
      NULL,
      2,
      2.361959,
      6,
      NULL,
      7,
      NULL,
      6.267140,
      1.919166,
      7.512691,
      NULL,
      3,
      0.172408,
      7,
      NULL,
      4.296867,
      0.214733,
      3,
      5,
      NULL,
      2.427002,
      2,
      NULL,
      1,
      1.000302,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.485549,
      0.875611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.727311,
      0.020753,
      2.740941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241854,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      2.920228,
      8.404078,
      0.096131,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.084271,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642927,
      0.915636,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3,
      1.901190,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1.537924,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.194071,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '14430',
      '',
      NULL,
      1.295402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


