set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '010',
      '43',
      8.557933,
      NULL,
      '3101114',
      99,
      0,
      2.700700,
      1,
      '130341',
      4,
      NULL,
      NULL,
      80,
      0,
      NULL,
      1,
      0.785869,
      2,
      0.543316,
      1,
      0,
      0.892878,
      0.455882,
      0,
      0,
      NULL,
      0.132088,
      0.107232,
      0.371506,
      NULL,
      2.284410,
      3.765459,
      0,
      0,
      NULL,
      0,
      0.381806,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834678,
      1,
      NULL,
      1.643661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2.969066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.250388,
      3,
      4.618711,
      0,
      1.973007,
      1.349399,
      0,
      NULL,
      0,
      0,
      0.533891,
      0.985481,
      1.088632,
      NULL,
      0,
      1.491591,
      1,
      NULL,
      1,
      NULL,
      0.523295,
      0.213939,
      7,
      0,
      NULL,
      0.318196,
      8.814006,
      0.469006,
      9,
      NULL,
      5,
      5.385806,
      NULL,
      NULL,
      0,
      NULL,
      5,
      9,
      8.690849,
      7.342243,
      5,
      8.634795,
      5.800848,
      3,
      0,
      NULL,
      1.712987,
      NULL,
      NULL,
      0.172395,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750673,
      0.930396,
      2,
      0,
      1.368598,
      1.221386,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339055,
      NULL,
      7,
      0.890144,
      3.589405,
      3.585100,
      3.609738,
      1.797181,
      1,
      NULL,
      3.807615,
      4.131372,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.364920,
      0,
      5.003793,
      NULL,
      0,
      NULL,
      1.894251,
      NULL,
      NULL,
      NULL,
      0,
      2.399820,
      1.244617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1.073110,
      0.210504,
      1.991752,
      2,
      0.838034,
      3,
      NULL,
      0.885546,
      0.452000,
      0,
      1.859275,
      NULL,
      NULL,
      0,
      1.077701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.894389,
      '41100',
      '',
      NULL,
      1.089942,
      '',
      NULL,
      '',
      NULL,
      '23241',
      '',
      NULL,
      2.644049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


