set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      NULL,
      5.384822,
      2.259313,
      '0201114',
      175.387361,
      NULL,
      NULL,
      0,
      NULL,
      3,
      ' 1-15-1993',
      13.264078,
      12.051883,
      NULL,
      NULL,
      2.964325,
      0.157970,
      3,
      1.233921,
      0.416323,
      1.697415,
      0.054973,
      1,
      NULL,
      0,
      1,
      1.139792,
      NULL,
      0.898339,
      1,
      NULL,
      0,
      NULL,
      0.528003,
      1.240541,
      0,
      1,
      0.211917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078037,
      1.011350,
      0,
      0.715289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.063330,
      1.602478,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175752,
      1.551001,
      4,
      NULL,
      1,
      0,
      1.549966,
      NULL,
      1.921074,
      NULL,
      NULL,
      1.850595,
      1.313198,
      1.288410,
      1.421100,
      0.628398,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      0.181989,
      NULL,
      0.027403,
      0.496356,
      1.752419,
      3.845667,
      6,
      5.822801,
      7,
      6.218135,
      0,
      6.546016,
      1.628784,
      0,
      7,
      9,
      11.949371,
      NULL,
      9.172174,
      3,
      11.370804,
      NULL,
      5,
      NULL,
      3.275409,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876585,
      0.499287,
      1,
      0,
      1,
      NULL,
      0,
      1.104074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.507746,
      NULL,
      9.409384,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.085710,
      2,
      0.685445,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.004080,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657092,
      0.866092,
      1.020539,
      1.186159,
      3,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      0.174720,
      0.898996,
      0.134516,
      1,
      0.272393,
      1.719371,
      0,
      0.144567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.144979,
      '32233',
      '',
      '',
      1,
      '',
      '',
      '',
      2.221611,
      NULL,
      '',
      '',
      NULL,
      1,
      0.360258,
      NULL,
      0.823968,
      1,
      2.201865,
      3.713290,
      0);
commit;
end;
/


