set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04244012',
      51,
      72.577917,
      '3021121',
      205.803334,
      0,
      1,
      3,
      '124201',
      6,
      ' 5-11-1999',
      40,
      61,
      0,
      NULL,
      5.212424,
      0.935689,
      2.936215,
      NULL,
      0,
      2.364207,
      1,
      NULL,
      NULL,
      0.750253,
      5.810659,
      0.799423,
      1,
      NULL,
      NULL,
      1.385834,
      2,
      1.702415,
      NULL,
      NULL,
      0.687141,
      1,
      4,
      NULL,
      5.565460,
      0.261152,
      1,
      0.673343,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.752330,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.939069,
      0.524420,
      2.945349,
      NULL,
      2.468394,
      1.205135,
      1.386756,
      0,
      1.525741,
      NULL,
      4,
      2.229642,
      0,
      NULL,
      0.830640,
      0.275615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.052072,
      1.992679,
      3.895659,
      4,
      1.627871,
      5.864084,
      0,
      1,
      0.136392,
      2.715123,
      0.661390,
      0,
      5,
      1,
      NULL,
      NULL,
      1,
      0.910940,
      NULL,
      1,
      1.993939,
      6,
      3.548232,
      1,
      4,
      0,
      0,
      NULL,
      2.292876,
      0,
      0,
      7.991591,
      3,
      7.264691,
      0,
      7,
      6,
      4,
      3.386679,
      6.045188,
      1.039974,
      7,
      6.370003,
      9.086494,
      1.761420,
      8,
      9,
      1,
      1.379102,
      1.028761,
      5.202738,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.914950,
      1.470328,
      3.374624,
      1.043863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.504893,
      NULL,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.950094,
      3.961035,
      0.396286,
      NULL,
      NULL,
      NULL,
      4,
      0,
      9,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8.820544,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912367,
      2,
      3.204930,
      0.763753,
      1,
      3.330865,
      0,
      NULL,
      3,
      1,
      2.631587,
      1.687768,
      NULL,
      0.129946,
      1,
      1,
      1,
      1.051417,
      1.751420,
      0.894414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '00421',
      '',
      '',
      0.250805,
      '',
      '',
      '',
      1,
      '22344',
      '3102',
      '34412',
      2.718938,
      7,
      1,
      2.134888,
      0.459445,
      1.949571,
      1,
      NULL,
      1);
commit;
end;
/


