set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4332',
      '02342444',
      53,
      76,
      '3014022',
      30,
      0,
      NULL,
      1,
      '100021',
      4.478003,
      ' 5-18-1982',
      37,
      54,
      0.658166,
      NULL,
      0,
      0.457581,
      2,
      0,
      1.417593,
      0.532782,
      1,
      1.913051,
      0.112144,
      1.170914,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.858359,
      1,
      NULL,
      1,
      NULL,
      1.583998,
      2.112858,
      NULL,
      0.257703,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.071066,
      NULL,
      NULL,
      1.971165,
      1.442026,
      1.159965,
      NULL,
      1.349148,
      0.710928,
      2,
      1,
      1.840557,
      3.571460,
      1,
      0,
      3.509711,
      NULL,
      1.057555,
      0,
      0.475355,
      1.518927,
      1,
      0,
      NULL,
      0.074171,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      6,
      4,
      3,
      NULL,
      NULL,
      1,
      0.293026,
      0,
      1,
      0,
      1.195419,
      0,
      NULL,
      1,
      1.232119,
      0.869387,
      NULL,
      0.089303,
      NULL,
      NULL,
      0.484403,
      1.280531,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.973567,
      NULL,
      NULL,
      2,
      0.536010,
      7.553019,
      1,
      NULL,
      2,
      11,
      5,
      NULL,
      1.341988,
      6.702930,
      NULL,
      7,
      NULL,
      0,
      NULL,
      2.811027,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0.590695,
      3.740884,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.308933,
      3.258094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.878397,
      5.153679,
      0.268965,
      2,
      0.730827,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.394363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.268446,
      3.797184,
      2.260232,
      2.751305,
      3,
      0,
      2,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      0.162323,
      1,
      1.437030,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.977699,
      '24023',
      '',
      '',
      0.184420,
      '',
      NULL,
      '',
      1,
      '42221',
      '0403',
      '43202',
      7,
      1.859414,
      2,
      2.859466,
      2,
      2.824829,
      2,
      NULL,
      NULL);
commit;
end;
/


