set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4334',
      '03433102',
      69.953966,
      NULL,
      '1441213',
      131,
      2,
      0,
      2,
      '434024',
      5,
      NULL,
      NULL,
      49.332058,
      0,
      NULL,
      1.427941,
      NULL,
      2.228491,
      0,
      NULL,
      2.777942,
      0,
      1.596586,
      NULL,
      0,
      5,
      0,
      1.004900,
      1,
      1.561440,
      0.278905,
      3.951385,
      NULL,
      3,
      0,
      1,
      NULL,
      3.361721,
      1,
      2.490257,
      NULL,
      0.568325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.067542,
      0.647918,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.066625,
      NULL,
      NULL,
      0,
      4.010393,
      1,
      6.324486,
      NULL,
      3.047215,
      3.514035,
      1.152799,
      1,
      2,
      0,
      NULL,
      1.448749,
      2.009238,
      1,
      NULL,
      NULL,
      1.976340,
      NULL,
      NULL,
      NULL,
      3.953457,
      2.986007,
      1.577891,
      3.811618,
      1.378250,
      2,
      NULL,
      1.217099,
      1.883595,
      1.321769,
      3,
      NULL,
      0,
      NULL,
      0,
      8.098290,
      9,
      4.865666,
      5.090730,
      1,
      9,
      NULL,
      8,
      7,
      1,
      4.251947,
      2,
      2.347428,
      0.648781,
      1,
      4.913241,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.807799,
      0,
      1,
      0.819909,
      2,
      3.715155,
      0.571792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.030383,
      NULL,
      6,
      2,
      0,
      1,
      2.934554,
      0.576476,
      0.454048,
      0,
      4.065854,
      5,
      NULL,
      0.264374,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.090285,
      1.187376,
      4.622868,
      0,
      0.908226,
      NULL,
      NULL,
      NULL,
      0.701171,
      NULL,
      1.328302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782923,
      0,
      1,
      NULL,
      NULL,
      0.238148,
      0,
      2,
      1.820408,
      2,
      3,
      1.496193,
      0.759666,
      0,
      0,
      0.381332,
      NULL,
      1,
      0,
      1.398387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '23010',
      '00302',
      '',
      1.581632,
      '',
      NULL,
      '',
      3,
      '01141',
      '2233',
      '24404',
      1.797660,
      2.917686,
      NULL,
      1.474308,
      NULL,
      2.987337,
      1.893832,
      1.254858,
      1);
commit;
end;
/


