set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1224',
      NULL,
      73.999824,
      NULL,
      NULL,
      NULL,
      5,
      2.638777,
      NULL,
      '013023',
      4,
      ' 2-27-1993',
      46.979543,
      60.907364,
      0.186822,
      NULL,
      2,
      1,
      3,
      1.231701,
      0.082730,
      3.909550,
      1.709722,
      1.830529,
      0,
      1,
      1.952917,
      1.060970,
      0,
      5,
      1.254676,
      1,
      3.281514,
      0,
      1.870403,
      1,
      1,
      8,
      0.795349,
      NULL,
      5,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.257390,
      1.201058,
      NULL,
      2.432454,
      0,
      1,
      NULL,
      1.359795,
      3,
      3,
      1,
      0,
      0.411199,
      3.536031,
      1.872259,
      3.813377,
      1.579192,
      0.000274,
      0.174427,
      0.175174,
      1,
      5,
      7.851882,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.443324,
      NULL,
      7.386192,
      5,
      4,
      3.871891,
      1.803195,
      NULL,
      1.460246,
      1.502527,
      2.859249,
      0,
      NULL,
      0.524075,
      0,
      NULL,
      NULL,
      1.755990,
      NULL,
      NULL,
      1.762507,
      NULL,
      4,
      0,
      0.834286,
      NULL,
      6,
      NULL,
      5,
      7,
      NULL,
      3,
      NULL,
      4,
      3,
      1,
      4,
      5,
      4.564805,
      2,
      8,
      4.574941,
      3.650896,
      0,
      9,
      0.393157,
      0.687655,
      0,
      0,
      1,
      NULL,
      5.913160,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035070,
      3.351886,
      1,
      0,
      1.703202,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8.438929,
      0,
      2,
      3.080986,
      3,
      0.946507,
      0.353151,
      NULL,
      0,
      2,
      3.376728,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.724358,
      7.280259,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.993327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.420827,
      NULL,
      0,
      0,
      1.452400,
      0.212202,
      NULL,
      3,
      2.710648,
      NULL,
      1,
      0,
      1.765699,
      NULL,
      0.153641,
      0,
      0,
      0,
      0.534347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.545000,
      NULL,
      '10304',
      '',
      1.439083,
      '',
      '',
      '',
      5,
      NULL,
      '4322',
      '21114',
      1.243275,
      NULL,
      3,
      3.577712,
      3.706508,
      1,
      3,
      NULL,
      NULL);
commit;
end;
/


