set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '12',
      10,
      NULL,
      '4200211',
      26.983498,
      6,
      3.164315,
      3,
      '113343',
      NULL,
      ' 7-23-1995',
      NULL,
      5.860098,
      1,
      NULL,
      1,
      1.084425,
      2,
      NULL,
      0,
      1.637572,
      0,
      1,
      NULL,
      1,
      0.761548,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0.690711,
      1.540921,
      0,
      0.336778,
      1.484475,
      1.721714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602008,
      1.427543,
      1,
      0.528607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.740882,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520669,
      0,
      0,
      NULL,
      0.826239,
      NULL,
      NULL,
      0,
      0.366322,
      0.493979,
      0,
      0.138341,
      1.430138,
      1,
      1.431278,
      1,
      0.084460,
      0,
      0.461606,
      NULL,
      1.597975,
      0,
      0.724021,
      NULL,
      0.970834,
      1.951287,
      1.375789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162509,
      NULL,
      1,
      0.723562,
      1.477030,
      1,
      0.726462,
      1.939746,
      1,
      1.562986,
      1.082348,
      3.056431,
      1.412613,
      1.643096,
      1.432839,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300644,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1.219494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455811,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.912979,
      1.335608,
      0.729595,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.892220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571939,
      1,
      NULL,
      0,
      1.928566,
      0.344397,
      0,
      0,
      0.121673,
      1,
      1.604896,
      0,
      NULL,
      0,
      1.887721,
      0.709875,
      0.006491,
      1.042155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.063604,
      '34000',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      5.233251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


