set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '421',
      '41',
      10.503568,
      39,
      '4344443',
      151.662730,
      4,
      NULL,
      0,
      NULL,
      4,
      '10- 4-1987',
      56,
      6.413430,
      0.567169,
      NULL,
      NULL,
      2.444052,
      1.271840,
      NULL,
      0.379778,
      0.032932,
      0.937316,
      3.912256,
      1,
      NULL,
      1.212655,
      0,
      NULL,
      0,
      1.079762,
      1.659502,
      0,
      0.697664,
      0.975134,
      0,
      0,
      1.311459,
      0.862750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434922,
      1.764236,
      1.948868,
      0.706700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.328287,
      0.120917,
      0.283906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.953623,
      NULL,
      1.032053,
      0.971243,
      NULL,
      0,
      NULL,
      3.271074,
      4,
      NULL,
      NULL,
      NULL,
      0.376625,
      0,
      1.630170,
      NULL,
      1.343345,
      NULL,
      1.220679,
      0.246633,
      0,
      NULL,
      0.957269,
      1.530848,
      1.489423,
      0,
      1,
      0.115640,
      1,
      NULL,
      0,
      NULL,
      1.406269,
      1,
      1,
      1,
      1.839958,
      1,
      NULL,
      7.588696,
      2.040919,
      4.027408,
      1.110258,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.025901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854827,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599686,
      NULL,
      NULL,
      NULL,
      NULL,
      3.406134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.617731,
      0,
      NULL,
      NULL,
      NULL,
      0.436035,
      0.027693,
      1,
      3.038597,
      NULL,
      1,
      0.662576,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.930840,
      1,
      1.414396,
      3,
      1,
      0,
      1,
      0.620728,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1.444708,
      0,
      1.998678,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653141,
      '42342',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.579499,
      NULL,
      '',
      '',
      2.858279,
      3.018490,
      1,
      NULL,
      NULL,
      NULL,
      3.124218,
      0,
      NULL);
commit;
end;
/


