set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '424',
      '04221032',
      29.454029,
      48.085667,
      '1140021',
      NULL,
      3,
      1.737026,
      3,
      '200442',
      NULL,
      ' 6-10-1976',
      36,
      5,
      1,
      NULL,
      1.113269,
      1.019138,
      0.307111,
      1,
      0.868324,
      1,
      3,
      NULL,
      0.142431,
      0,
      1,
      1,
      1,
      1.196741,
      0.223232,
      1.254382,
      0,
      0,
      1.900491,
      1.693660,
      1,
      0.385966,
      1.532441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.526152,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.296494,
      1.485089,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.952358,
      1,
      2,
      0,
      1.798028,
      2.632914,
      0,
      1,
      NULL,
      2.410533,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.975126,
      1.963634,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174081,
      NULL,
      NULL,
      0.563097,
      0,
      NULL,
      0,
      NULL,
      0.245326,
      NULL,
      5,
      NULL,
      NULL,
      1,
      0.805944,
      1.718419,
      0.835340,
      NULL,
      NULL,
      2.755105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449553,
      1.614194,
      1,
      1,
      1,
      0.987423,
      1,
      0.768390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556180,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.486459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994833,
      0,
      3.842432,
      2,
      1.573851,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554768,
      0,
      1.063905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085378,
      0,
      1,
      1,
      3.393194,
      1.502255,
      0.676185,
      1.534702,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.211982,
      NULL,
      0.406642,
      NULL,
      1.910323,
      1.951735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.219453,
      NULL,
      NULL,
      '',
      1.067199,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.176188,
      7,
      0,
      0,
      1,
      NULL,
      5.895058,
      NULL,
      0.711249);
commit;
end;
/


