set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02114141',
      63.815733,
      24,
      NULL,
      89.346532,
      2,
      NULL,
      0,
      '232133',
      NULL,
      '11- 9-1981',
      21.185848,
      26.651360,
      NULL,
      NULL,
      1.261498,
      0.748572,
      3,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.392916,
      NULL,
      0.983196,
      0.337505,
      0,
      NULL,
      NULL,
      1.137865,
      0,
      NULL,
      1.555640,
      1,
      1,
      1,
      0.280178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932848,
      1.155501,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.944649,
      0,
      1.959791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.466965,
      0.593689,
      0.951241,
      NULL,
      NULL,
      1.438096,
      0,
      1.138721,
      0.959443,
      1.339379,
      1.009858,
      0.941125,
      1.321723,
      0.210412,
      1.974197,
      0.718995,
      1.912733,
      0,
      NULL,
      0.903009,
      NULL,
      0.627802,
      1.453507,
      1,
      1,
      0.388048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.658456,
      0,
      NULL,
      1.760459,
      3.629571,
      NULL,
      6,
      1.000475,
      0.190594,
      NULL,
      5.985174,
      0.321197,
      1,
      NULL,
      1.656999,
      NULL,
      NULL,
      NULL,
      0.045495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262696,
      1,
      1,
      0,
      0.964605,
      0,
      NULL,
      1.595903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260332,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.998652,
      0,
      NULL,
      NULL,
      NULL,
      1.963597,
      1,
      NULL,
      4,
      1.945790,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.643756,
      5,
      1.408251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.418192,
      0,
      1.324534,
      1.998309,
      NULL,
      1.364212,
      NULL,
      1.889064,
      1,
      0,
      NULL,
      1,
      1,
      0.535346,
      0.940260,
      0.151995,
      0.592401,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.592112,
      NULL,
      '',
      '',
      0.761741,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      0.623621,
      0.580428,
      NULL,
      2,
      2.511969,
      NULL,
      0,
      0);
commit;
end;
/


