set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2221',
      NULL,
      NULL,
      29.707421,
      '0014424',
      55,
      3,
      3.534787,
      0,
      NULL,
      0.265310,
      ' 4-23-1979',
      49,
      16,
      NULL,
      NULL,
      1.980151,
      0,
      1,
      0,
      0.937672,
      0,
      1.293465,
      1,
      1.949696,
      1,
      0.563162,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1.581758,
      1,
      0.980771,
      1,
      1,
      NULL,
      3.249873,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960109,
      0.333546,
      1.431513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.582803,
      NULL,
      1.847891,
      0.288674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.950566,
      1,
      3,
      1,
      0.408714,
      1.920359,
      NULL,
      1,
      0,
      1,
      NULL,
      0.113141,
      NULL,
      5.215340,
      1.841145,
      1,
      1,
      0.128713,
      NULL,
      NULL,
      0,
      1.513563,
      NULL,
      0.976502,
      NULL,
      0.254097,
      1,
      0.332464,
      1,
      1.423175,
      1,
      NULL,
      2,
      3.279152,
      0.317801,
      0.361911,
      1.024063,
      NULL,
      9.541952,
      5,
      0,
      4,
      3,
      7,
      NULL,
      1.706520,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.393747,
      1,
      1,
      1.067384,
      0.966865,
      0.732796,
      0.385724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9,
      0.579864,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.959166,
      2,
      0.686418,
      NULL,
      NULL,
      NULL,
      0.220886,
      1,
      5.016353,
      1.859686,
      5.525350,
      1,
      1.416632,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.409987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.814449,
      0.566007,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      0.752940,
      0.046305,
      0,
      NULL,
      0,
      0.787671,
      0,
      0,
      0,
      0.996272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.973145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.705510,
      0.023380,
      1,
      NULL,
      1.518612,
      1,
      0,
      0,
      0.120268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.716657,
      '34023',
      NULL,
      '',
      1.336724,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      3.030675,
      NULL,
      NULL,
      3.970321,
      1.041542,
      NULL,
      2.429564,
      0,
      2);
commit;
end;
/


