set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0030',
      '32134031',
      39.039620,
      10,
      NULL,
      28,
      NULL,
      0,
      NULL,
      '313022',
      5,
      NULL,
      21,
      2,
      0.539234,
      NULL,
      1.362398,
      NULL,
      1.970498,
      0.374067,
      NULL,
      0,
      1.090313,
      1.695169,
      0.806105,
      0,
      NULL,
      0,
      3.611897,
      NULL,
      NULL,
      1.331659,
      NULL,
      0,
      1,
      NULL,
      1.273662,
      1.354224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.840913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337718,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.447108,
      1.763044,
      0,
      1.733853,
      NULL,
      0,
      1,
      5,
      0.741873,
      NULL,
      1,
      4,
      0,
      0,
      1,
      1.850111,
      NULL,
      NULL,
      1.304144,
      1.540567,
      NULL,
      4,
      1,
      1,
      4.357647,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.363415,
      1.101433,
      NULL,
      NULL,
      0.350936,
      9.250906,
      2,
      NULL,
      8,
      NULL,
      1.090005,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      9.773490,
      1.231853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.179371,
      0,
      0,
      0.927713,
      1.788939,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.978474,
      2,
      1.542163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.935006,
      3.638166,
      NULL,
      0.402331,
      NULL,
      NULL,
      NULL,
      NULL,
      3.849813,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.330006,
      1,
      1.481477,
      1.702385,
      3.448124,
      1.453387,
      1,
      NULL,
      0.847678,
      1,
      1,
      1.099645,
      0,
      0,
      1.658806,
      0.097443,
      1,
      0.883503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.842493,
      '22400',
      '',
      NULL,
      0.416256,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      2.567436,
      2.218032,
      3.134601,
      2.267276,
      5.257195,
      3.181223,
      NULL,
      0.061153);
commit;
end;
/


