set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3322',
      '40440000',
      38.396061,
      11,
      '2341032',
      198,
      5,
      0,
      NULL,
      '031001',
      3,
      '11-26-1998',
      14.806441,
      45,
      NULL,
      NULL,
      1.863147,
      0.564969,
      NULL,
      NULL,
      0,
      0.123937,
      NULL,
      2.090812,
      1,
      0,
      NULL,
      0.366162,
      4,
      0,
      0,
      NULL,
      NULL,
      1,
      4.464227,
      1,
      1,
      0.924040,
      4,
      0,
      NULL,
      0,
      3.053973,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.749472,
      0,
      NULL,
      0,
      1.195453,
      NULL,
      2.817125,
      NULL,
      NULL,
      0.927070,
      0.058320,
      0.485536,
      2,
      NULL,
      NULL,
      1,
      0.645435,
      2,
      2.550190,
      1,
      NULL,
      0.663688,
      3.572060,
      1,
      NULL,
      NULL,
      1.327848,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.246694,
      2,
      1,
      2,
      0,
      5.868970,
      1,
      1,
      NULL,
      0,
      NULL,
      1.678481,
      2,
      1.033179,
      1,
      1.725262,
      0.501737,
      0.423833,
      NULL,
      NULL,
      6,
      NULL,
      2.921965,
      4,
      1,
      NULL,
      0.665656,
      6.393160,
      NULL,
      1.782337,
      0,
      3,
      5.532334,
      4,
      0,
      4.700963,
      0,
      6,
      8.009292,
      NULL,
      5,
      1,
      2.605338,
      2.534615,
      4.017440,
      0,
      2,
      0.251533,
      NULL,
      NULL,
      1.672106,
      1.865597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.059531,
      1.593040,
      1.020530,
      0.249666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.164134,
      NULL,
      3.982524,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.473754,
      3,
      2.413001,
      3,
      2,
      NULL,
      NULL,
      0.717147,
      NULL,
      NULL,
      0,
      0.912653,
      1.195068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361142,
      1.800420,
      0,
      1.484548,
      0.789491,
      0,
      1,
      NULL,
      0,
      3,
      2,
      1.665994,
      NULL,
      0,
      0,
      1.599082,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      1.715740,
      '',
      NULL,
      '',
      1.545785,
      '',
      '',
      '',
      0,
      4,
      0,
      1,
      1.025209,
      0.003977,
      0,
      0,
      5.656159);
commit;
end;
/


