set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2032',
      '10442230',
      NULL,
      57,
      '3441040',
      16,
      2,
      NULL,
      NULL,
      NULL,
      5.603520,
      ' 0- 9-1991',
      37,
      6.274595,
      NULL,
      NULL,
      NULL,
      0.536920,
      0,
      0.698901,
      NULL,
      1.266132,
      NULL,
      1.816926,
      NULL,
      1,
      0.593115,
      1.485024,
      0.763851,
      NULL,
      1,
      1,
      1.976679,
      0.159311,
      0,
      1,
      0.819365,
      NULL,
      3.513406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018862,
      0.274840,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.135604,
      0.621611,
      1.402784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842350,
      NULL,
      4,
      NULL,
      1,
      0.969692,
      1,
      1.385590,
      1.649941,
      1,
      0,
      1,
      NULL,
      0.741563,
      1.309111,
      1.969375,
      0.674001,
      NULL,
      0.757290,
      1,
      1,
      0.192916,
      0,
      1,
      1.720390,
      0,
      1,
      0.016764,
      1,
      1,
      NULL,
      0.344125,
      0.637922,
      1.134902,
      1.980789,
      NULL,
      2,
      3,
      NULL,
      3.251988,
      4,
      7,
      4.750284,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.924240,
      NULL,
      0.368274,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377616,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883758,
      3.142584,
      2,
      1,
      1.916467,
      5.629001,
      0.175101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716874,
      0,
      3.586218,
      0,
      NULL,
      1.882446,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491285,
      1.527621,
      0.950897,
      2,
      1,
      NULL,
      1.162729,
      NULL,
      1,
      0,
      1.020941,
      1.993750,
      1,
      0,
      0,
      NULL,
      NULL,
      0.927383,
      0.723408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.600822,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      1.821114,
      '',
      '',
      '',
      2.233235,
      NULL,
      NULL,
      1.556769,
      3,
      0.588858,
      2,
      3,
      NULL);
commit;
end;
/


