set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4142',
      '32134004',
      32,
      NULL,
      '3231331',
      21.182519,
      4,
      3.033329,
      2,
      '430130',
      3,
      '11-23-1984',
      35.280353,
      NULL,
      0,
      NULL,
      1.601841,
      NULL,
      1,
      1.252460,
      0.982298,
      NULL,
      0.824585,
      1,
      1.821254,
      1.927527,
      NULL,
      NULL,
      1,
      1.701792,
      0,
      1,
      1.390123,
      1,
      1.457748,
      NULL,
      0.857281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.004781,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638662,
      1.154885,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122481,
      1.918326,
      3,
      NULL,
      1,
      1,
      1.566400,
      1,
      NULL,
      0,
      1.079316,
      NULL,
      1,
      0,
      1,
      0.224896,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1.209818,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.393639,
      0.802904,
      0.410980,
      1.501008,
      1.949433,
      0.238973,
      5.139770,
      1.364337,
      1.043161,
      NULL,
      NULL,
      NULL,
      1.808874,
      1,
      NULL,
      0.018799,
      NULL,
      NULL,
      8.580911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451867,
      0.217691,
      0,
      0,
      NULL,
      1,
      NULL,
      0.453835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567858,
      1.033749,
      1,
      1,
      0.972026,
      0,
      1.083942,
      NULL,
      NULL,
      NULL,
      0.391461,
      1.967371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176022,
      0.377043,
      1,
      0.771937,
      0.575688,
      1.188840,
      0.661676,
      NULL,
      NULL,
      2.714026,
      NULL,
      1.664788,
      0,
      1.696624,
      NULL,
      0.265759,
      1.218032,
      1,
      0.435998,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '11041',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.126867,
      NULL,
      '',
      NULL,
      4,
      0.481809,
      1,
      3,
      2.460480,
      2,
      3.398959,
      0.395888,
      2);
commit;
end;
/


