set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9966597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0212',
      '23004010',
      22,
      60.726231,
      '1230344',
      NULL,
      NULL,
      2,
      0,
      '441131',
      0.987441,
      NULL,
      125.562674,
      83,
      0,
      NULL,
      0,
      1.017684,
      1,
      0.127050,
      NULL,
      NULL,
      2,
      1,
      0,
      0.728563,
      3,
      1,
      NULL,
      1,
      1,
      5,
      0.357998,
      0,
      1,
      1.984509,
      0.938806,
      1,
      NULL,
      NULL,
      3,
      3.778153,
      0,
      0,
      NULL,
      NULL,
      1.621428,
      NULL,
      NULL,
      8,
      7,
      4.242265,
      3.113586,
      NULL,
      0,
      1,
      1,
      NULL,
      2.901810,
      1.339435,
      1.839490,
      2,
      2,
      NULL,
      0,
      0.801572,
      1,
      1.399407,
      0,
      NULL,
      NULL,
      3,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.553633,
      0,
      0.269170,
      0.393574,
      NULL,
      NULL,
      0.892829,
      0,
      0,
      2.588931,
      0,
      5,
      NULL,
      1.344462,
      0.762902,
      0,
      1.975725,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139633,
      5.554089,
      0.584616,
      1.387261,
      1,
      2,
      0.236489,
      1,
      1,
      NULL,
      1.941160,
      NULL,
      1,
      4,
      1.557442,
      NULL,
      3,
      3,
      0.527338,
      3,
      1.805257,
      NULL,
      3.996391,
      3.895764,
      1,
      0,
      1.546910,
      1,
      0.638186,
      0.591090,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691272,
      1.491726,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903207,
      1,
      0.553645,
      1.467612,
      NULL,
      1.420720,
      0.850381,
      NULL,
      4.962534,
      NULL,
      3.684176,
      2,
      1.809029,
      NULL,
      NULL,
      NULL,
      1.439267,
      2.410645,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901021,
      NULL,
      1.321819,
      3.789270,
      0.219885,
      0,
      3,
      2,
      1,
      2.508008,
      0,
      1.467443,
      0.239482,
      1,
      0,
      1.323542,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.153885,
      '00344',
      '',
      '',
      1.139452,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      4.013197,
      NULL,
      2.519328,
      NULL,
      1,
      1.335911,
      NULL,
      NULL,
      2);
commit;
end;
/


