set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9966597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01342001',
      35,
      NULL,
      '1244043',
      NULL,
      3,
      0,
      3,
      NULL,
      4.821767,
      '11-23-2003',
      136,
      1.992246,
      0.222286,
      NULL,
      1,
      0.299263,
      2,
      1.850731,
      0,
      0,
      NULL,
      0.186621,
      0.249932,
      1.843330,
      3,
      1,
      NULL,
      1,
      1.214636,
      3,
      5.520960,
      1.975667,
      2.686281,
      1,
      1.536288,
      NULL,
      1,
      1,
      5,
      3,
      NULL,
      0.400483,
      NULL,
      NULL,
      1.385988,
      NULL,
      NULL,
      3,
      6.298088,
      NULL,
      2,
      1,
      1,
      2,
      1.714490,
      1,
      3.902348,
      0.755102,
      0,
      NULL,
      1,
      2,
      1,
      1,
      0,
      0.350283,
      1,
      1.514772,
      0,
      3.804803,
      1,
      2,
      1.081283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014875,
      0,
      0,
      1.703363,
      1.160604,
      0.954759,
      0.799239,
      1.305733,
      0.012137,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1.378564,
      0,
      0.605607,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      1.015159,
      0,
      2,
      0.574152,
      5,
      3,
      5,
      4.432104,
      0.703888,
      3,
      1,
      1.653965,
      NULL,
      0.186362,
      1.659992,
      1,
      1.035242,
      2.619957,
      0,
      0,
      NULL,
      0,
      1,
      1.681048,
      2,
      1,
      NULL,
      2,
      1.869577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1.090386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118683,
      0,
      1,
      1,
      0,
      1.598666,
      NULL,
      NULL,
      NULL,
      0.020133,
      1.196515,
      1.412030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586203,
      0,
      NULL,
      NULL,
      NULL,
      3.424609,
      0,
      2,
      0.301403,
      1,
      0.326900,
      1,
      1.581535,
      0.972610,
      0,
      1.956853,
      1.185526,
      1.222352,
      NULL,
      1.037728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '21131',
      '30213',
      '',
      NULL,
      '',
      '',
      '',
      0.874777,
      '',
      '',
      '',
      4.257394,
      0.630460,
      NULL,
      1,
      NULL,
      2.410785,
      3,
      2.521213,
      NULL);
commit;
end;
/


