set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9966597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1323',
      '34040240',
      51.217984,
      60,
      '2101042',
      2,
      0,
      NULL,
      NULL,
      '401001',
      4.397803,
      ' 3-16-1979',
      78.472383,
      44.151156,
      1.715715,
      NULL,
      3.150927,
      1,
      1.677294,
      1.481745,
      1,
      0,
      NULL,
      0,
      NULL,
      1.711181,
      3.001774,
      NULL,
      0.349107,
      1.687657,
      NULL,
      1,
      0,
      0.608670,
      NULL,
      1.623868,
      NULL,
      1.618735,
      4.559173,
      NULL,
      2.676344,
      5,
      1.877326,
      0.631536,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      8,
      1,
      NULL,
      1.558096,
      NULL,
      2,
      0,
      1,
      2.888263,
      3,
      0,
      1.950510,
      0,
      NULL,
      2,
      2,
      1,
      0.714058,
      0,
      1.950697,
      3.794525,
      0.922046,
      1,
      1,
      NULL,
      1.014388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1,
      5,
      0,
      0.919029,
      0,
      1,
      0.849083,
      0,
      2,
      0.333141,
      1,
      0,
      0.607519,
      NULL,
      0.882883,
      1.673165,
      NULL,
      1,
      NULL,
      NULL,
      4.935534,
      6,
      0,
      1,
      2.283719,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      6.875264,
      0.199147,
      0.386154,
      NULL,
      NULL,
      5.658824,
      8,
      1.008106,
      6.763792,
      NULL,
      8.826394,
      9.172393,
      NULL,
      0,
      0.089934,
      1.098863,
      NULL,
      0.510359,
      1.242328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019685,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521530,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.360907,
      NULL,
      0.521179,
      1.613836,
      3.107232,
      1.066583,
      1.615509,
      NULL,
      NULL,
      NULL,
      NULL,
      0.775246,
      NULL,
      6,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.238322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      3.140817,
      3,
      3,
      1.188866,
      0.055031,
      NULL,
      NULL,
      0.194070,
      NULL,
      1.441750,
      NULL,
      NULL,
      NULL,
      1,
      0.015803,
      0.946767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '12124',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      5.248120,
      2,
      0,
      4,
      3.639267,
      3,
      3,
      NULL,
      1.005421);
commit;
end;
/


