set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7909684';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      '12',
      29.826530,
      10.561135,
      '2213233',
      3,
      NULL,
      0.920798,
      2,
      '004130',
      1,
      ' 6-26-1991',
      6,
      9.444387,
      1,
      NULL,
      NULL,
      1.552877,
      1,
      NULL,
      1.051449,
      1.950612,
      2,
      2,
      0.825350,
      0,
      NULL,
      1.958412,
      1,
      0,
      0.250679,
      0.655288,
      2.180242,
      NULL,
      1,
      0.661281,
      4.936815,
      1.889805,
      NULL,
      1,
      0.840216,
      1.898820,
      0.808054,
      1.647299,
      NULL,
      NULL,
      0.568398,
      NULL,
      NULL,
      4,
      0.356966,
      0.754440,
      3.393411,
      0.298727,
      1,
      NULL,
      1,
      0.767504,
      NULL,
      1.516068,
      0,
      1,
      1.493794,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1.407726,
      1,
      0.366396,
      0,
      2,
      3.370457,
      0.909804,
      NULL,
      NULL,
      1.000762,
      NULL,
      NULL,
      2,
      5.162862,
      1.003807,
      1,
      2,
      0,
      4,
      NULL,
      1,
      0.977131,
      1,
      1.785540,
      1.486973,
      2.476688,
      1,
      0.827088,
      0,
      0.636757,
      1.929819,
      NULL,
      NULL,
      4,
      0.737402,
      5,
      0,
      2,
      0.562548,
      0.740808,
      2.277948,
      1.721869,
      0,
      1.169874,
      0,
      1,
      4,
      NULL,
      NULL,
      3.603740,
      3,
      4,
      0.497943,
      3.201384,
      1.009106,
      1,
      5.052090,
      1.878922,
      4,
      4,
      1,
      3.259001,
      1.615481,
      NULL,
      0.974042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.582951,
      0.536489,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.492266,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.486535,
      0.819077,
      NULL,
      NULL,
      NULL,
      0.729328,
      1,
      2.166787,
      0.594470,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      0.672173,
      1.140933,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      2,
      2.409071,
      NULL,
      2.403034,
      0,
      NULL,
      1,
      1.062876,
      1.654794,
      0.956337,
      1.837979,
      1.124506,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.125818,
      '42313',
      '3302',
      NULL,
      1.630764,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


