set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '1103320',
      4.389597,
      5,
      2,
      NULL,
      '414023',
      0.564593,
      NULL,
      35,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      1,
      1.687979,
      0,
      0,
      1.349205,
      0.194067,
      2.323994,
      1,
      1.716460,
      1,
      NULL,
      0,
      5.138432,
      1.751260,
      0,
      1.903766,
      1,
      0,
      NULL,
      0,
      NULL,
      1.539476,
      1.272384,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1.368618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.778444,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.856333,
      1.459783,
      1.057329,
      NULL,
      0,
      1.748702,
      0.429902,
      1,
      0,
      0,
      1.472229,
      1.665844,
      1.031629,
      0,
      1,
      1.376830,
      NULL,
      0.636154,
      1,
      0.741832,
      1.177050,
      3.279788,
      1,
      2.564632,
      0.047890,
      0,
      1,
      NULL,
      0.013042,
      1.219303,
      NULL,
      3.597535,
      0,
      0.420770,
      0,
      0,
      0,
      NULL,
      1,
      0,
      4,
      NULL,
      0,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      1.031509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908119,
      0.094423,
      1,
      0,
      0.889921,
      1,
      0.309402,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.959783,
      2.403600,
      NULL,
      1,
      0.012692,
      NULL,
      NULL,
      NULL,
      0,
      0.996183,
      1.820201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353133,
      NULL,
      0.182992,
      0.288687,
      1.070800,
      0.732039,
      1.875845,
      NULL,
      0.762204,
      0,
      0.718636,
      1,
      0.964370,
      1.505124,
      1.912387,
      NULL,
      1.578450,
      0.672705,
      1.218280,
      0.086602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.591623,
      '24334',
      '',
      '',
      1,
      '',
      '',
      '',
      0.547131,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


