set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '3144203',
      15.253072,
      3,
      3.257046,
      0,
      NULL,
      3,
      NULL,
      34,
      NULL,
      1,
      NULL,
      6,
      0.418650,
      0,
      0.875395,
      1,
      1.083948,
      NULL,
      0,
      1.290815,
      0.665404,
      7.001181,
      1.572280,
      1,
      2,
      1,
      1.002294,
      7,
      1.559367,
      0.886319,
      1.661759,
      0,
      1.763571,
      3.864591,
      1,
      0,
      NULL,
      0.032179,
      NULL,
      NULL,
      NULL,
      1.622664,
      NULL,
      NULL,
      1.097065,
      1.175047,
      0.063430,
      0.323490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898468,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.698290,
      1,
      1,
      0,
      1,
      0,
      0,
      0.756961,
      1.410839,
      1.136795,
      0.482869,
      0.110139,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.341788,
      0,
      0,
      NULL,
      0.984195,
      1.245234,
      1,
      0.844159,
      0.891868,
      0.025413,
      0.707162,
      0.421227,
      3.077979,
      1.865598,
      1.876291,
      4.622895,
      NULL,
      2,
      8,
      9.519742,
      1.263235,
      0.952842,
      0,
      3,
      1.358974,
      NULL,
      4.207310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718455,
      1.220121,
      NULL,
      0,
      1,
      2,
      1,
      0.857164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624932,
      NULL,
      2,
      1.911501,
      0.688485,
      0.208263,
      1.928471,
      1,
      NULL,
      0,
      1,
      4.369093,
      0,
      1.735982,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.801141,
      NULL,
      1.609678,
      NULL,
      NULL,
      NULL,
      0.420109,
      NULL,
      0.483684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569751,
      NULL,
      2.403560,
      0.137071,
      3,
      0.681024,
      3,
      0,
      1,
      0.600867,
      0,
      1.021126,
      NULL,
      0.330151,
      1.906441,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '22033',
      NULL,
      NULL,
      0.319089,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


