set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '1234223',
      39.848303,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 3- 8-1975',
      25,
      NULL,
      1,
      NULL,
      NULL,
      0.516975,
      2.286684,
      NULL,
      1.942142,
      0,
      1,
      0,
      3,
      1.408792,
      0.340371,
      2,
      0.053326,
      1.199475,
      0,
      0.149983,
      5,
      1.291365,
      0,
      NULL,
      1,
      0.721874,
      3.916596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509669,
      NULL,
      1.156594,
      1.827128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988905,
      0.962801,
      0.941842,
      0.781555,
      0,
      1.680316,
      0,
      1.769808,
      0.110054,
      NULL,
      0.496152,
      1,
      NULL,
      0.720748,
      1.181307,
      0.565171,
      0.834079,
      1,
      NULL,
      NULL,
      0.812618,
      0.624715,
      0.578537,
      0.753142,
      0,
      1,
      0.444434,
      1.728350,
      0,
      1.343686,
      0,
      0.039198,
      0,
      1.996862,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5.284724,
      6.213305,
      1,
      5.901176,
      6.532312,
      6.138542,
      3,
      7.716605,
      0.724648,
      NULL,
      NULL,
      1,
      0.422221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.913952,
      0,
      1,
      1,
      NULL,
      0.977834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769747,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.077243,
      0.504484,
      0.762680,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450132,
      2.648270,
      4,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.766587,
      1.234431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.704969,
      0,
      0,
      1.261381,
      NULL,
      1.590041,
      0,
      0,
      0,
      0.107388,
      NULL,
      0.374707,
      NULL,
      0.014822,
      0.133420,
      0,
      0.376662,
      0,
      0.576027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '00242',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


