set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      '23',
      4,
      NULL,
      NULL,
      10,
      5,
      3,
      2,
      '423202',
      0,
      NULL,
      39.267376,
      NULL,
      NULL,
      NULL,
      1.246665,
      1,
      2.387569,
      1,
      NULL,
      2,
      NULL,
      1,
      2,
      1,
      4.127401,
      0.893838,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.644799,
      1.327606,
      0,
      NULL,
      2,
      NULL,
      3.431585,
      0.487460,
      1,
      0.778828,
      NULL,
      NULL,
      0,
      2.506637,
      0.221111,
      1.272122,
      1.323443,
      0.043711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.198032,
      0.766805,
      1.299732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      3,
      NULL,
      1.212701,
      0,
      NULL,
      0.847729,
      0.501453,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1.460658,
      1,
      NULL,
      NULL,
      0.812133,
      NULL,
      0,
      NULL,
      0.637414,
      0,
      0,
      1.488543,
      5,
      NULL,
      1,
      3.048095,
      0.830141,
      4,
      1.444766,
      1.421180,
      NULL,
      6.439084,
      6,
      1,
      5,
      1,
      1,
      2.157462,
      5.721693,
      3,
      0.480487,
      1.657484,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353599,
      0,
      NULL,
      1,
      0.940507,
      1,
      0.694493,
      1.391592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      2.215192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.412553,
      1.886518,
      1.434122,
      NULL,
      0.456139,
      0,
      3,
      1.394961,
      0,
      5,
      3,
      2,
      5,
      1,
      NULL,
      NULL,
      2,
      4.408001,
      2.782714,
      1.480700,
      NULL,
      1.851306,
      1,
      NULL,
      1.132282,
      0.462165,
      2,
      2.108827,
      1,
      0.978920,
      0.839843,
      3,
      2,
      1,
      0.594433,
      0,
      1,
      0,
      NULL,
      NULL,
      1.559040,
      0,
      NULL,
      0.939193,
      0.359427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '44344',
      '',
      '',
      0.801797,
      '',
      '',
      '',
      7.387993,
      '2324',
      '0242',
      NULL,
      3.429252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


