set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '004',
      '12434142',
      40,
      NULL,
      NULL,
      177.898953,
      2,
      3,
      1,
      '334001',
      3.886991,
      NULL,
      NULL,
      42,
      0.730231,
      NULL,
      NULL,
      1,
      3,
      1,
      1.196322,
      NULL,
      1.003270,
      1.823641,
      1,
      0,
      2.364625,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.927385,
      0,
      0.118622,
      NULL,
      1,
      0,
      5.591818,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.068907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602266,
      1.003837,
      1.494865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.563516,
      3,
      1,
      3.788302,
      0.361099,
      1.655244,
      1,
      NULL,
      1.517552,
      1,
      NULL,
      0.120299,
      1,
      NULL,
      NULL,
      1,
      0,
      1.826642,
      NULL,
      NULL,
      5.993150,
      1.218952,
      5.867854,
      2.801561,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      0,
      4.139612,
      1,
      NULL,
      6.664647,
      NULL,
      7.712267,
      6.171629,
      9,
      3.663765,
      NULL,
      2,
      2.569597,
      0,
      NULL,
      NULL,
      1.175409,
      0.262644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976262,
      0,
      1,
      0.740867,
      0,
      0.289858,
      0.406426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470641,
      NULL,
      0,
      0,
      1.074025,
      NULL,
      2,
      NULL,
      0.314418,
      0,
      5,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.927459,
      NULL,
      2,
      0.517086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.475778,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.900164,
      0,
      2.619082,
      0.721222,
      2.293530,
      2.884543,
      1,
      2.188598,
      0.435729,
      1.968883,
      1.435288,
      1.887328,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.496929,
      '24213',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.403813,
      NULL,
      '2431',
      '',
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0.038511,
      0,
      3.844046);
commit;
end;
/


