set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      '02324002',
      54,
      32.528516,
      '4431323',
      40,
      4,
      0,
      0,
      '441124',
      NULL,
      ' 7- 8-1988',
      32,
      0,
      NULL,
      NULL,
      1.115991,
      NULL,
      2.177534,
      0,
      1,
      0,
      0.743143,
      0.137109,
      0.815962,
      1,
      5.066734,
      0,
      2,
      0.917420,
      0,
      1,
      NULL,
      1.950054,
      1.971934,
      0,
      0,
      0.182374,
      NULL,
      1,
      2.200627,
      NULL,
      1.800826,
      0,
      NULL,
      NULL,
      3,
      4,
      NULL,
      1.663542,
      1,
      1.833768,
      0.615582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.398374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269321,
      NULL,
      0,
      5,
      1.292404,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.266366,
      0.102658,
      1,
      1,
      1,
      NULL,
      NULL,
      5.813746,
      0,
      0,
      0.003682,
      1,
      0.452039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693433,
      4.303949,
      1.500251,
      NULL,
      2.961193,
      7,
      0.453404,
      4.271988,
      5.040022,
      2,
      4.889980,
      4,
      2,
      0.836382,
      4,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.249220,
      NULL,
      NULL,
      2,
      2.832889,
      3.533513,
      3.792139,
      2,
      1,
      1,
      3.125837,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.231710,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      4,
      NULL,
      NULL,
      3.655043,
      0,
      0.978905,
      NULL,
      1.264851,
      1.613306,
      0,
      NULL,
      NULL,
      3.922931,
      0,
      0,
      2,
      2.017870,
      1.066740,
      0.558055,
      NULL,
      1.926842,
      0,
      1.126383,
      1.758148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.056082,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      3.854149,
      '2411',
      '1114',
      '',
      2.926109,
      6.356362,
      NULL,
      0,
      NULL,
      2,
      3.570334,
      1.828302,
      0.902447);
commit;
end;
/


