set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '332',
      '14010142',
      46.208440,
      NULL,
      '0233430',
      128,
      NULL,
      NULL,
      NULL,
      '314013',
      0.222579,
      ' 8-18-1976',
      34.885077,
      23,
      1,
      NULL,
      1.410144,
      1.760965,
      2,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0.443585,
      1.441072,
      0,
      1.676602,
      1.348727,
      0.827884,
      0.068903,
      1,
      0.472972,
      0.088234,
      0,
      0,
      1.694401,
      0.702385,
      1,
      1.465613,
      0,
      3,
      1.129500,
      NULL,
      NULL,
      3,
      1.275180,
      1.438396,
      NULL,
      0,
      1,
      0.017871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474848,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700764,
      0,
      1.339062,
      1,
      3.131757,
      1.192724,
      NULL,
      1,
      NULL,
      1,
      1.318183,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1.785302,
      1,
      NULL,
      1.212337,
      NULL,
      0.697143,
      1,
      2.147459,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5.799391,
      NULL,
      0,
      0,
      4.837159,
      1.539025,
      1,
      NULL,
      4,
      NULL,
      3.253075,
      11.165164,
      7.287273,
      NULL,
      NULL,
      0.248993,
      1.326544,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.480928,
      1.211770,
      0,
      1.026786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.443878,
      NULL,
      1,
      1,
      NULL,
      3.538334,
      2,
      3,
      1.358003,
      NULL,
      3.942262,
      6,
      0.821805,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635923,
      9.579337,
      5,
      4,
      1,
      0.340828,
      NULL,
      NULL,
      NULL,
      3,
      4,
      3,
      0,
      0,
      0.579114,
      0,
      0,
      0.002395,
      0.958473,
      2,
      3.274482,
      0,
      3,
      2,
      3,
      2.916652,
      0,
      0.424141,
      2.609909,
      0.954870,
      NULL,
      1.263748,
      1,
      1,
      1.343929,
      0,
      0.979368,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.454524,
      '40432',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      '4333',
      '',
      2,
      0,
      2.324506,
      NULL,
      2,
      3.296502,
      2.272436,
      3,
      2);
commit;
end;
/


