set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20124212',
      29,
      37,
      '3131404',
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      72,
      1,
      NULL,
      1,
      1.154148,
      NULL,
      NULL,
      0,
      1,
      1.750157,
      NULL,
      0,
      0.385565,
      NULL,
      4.040714,
      1.631084,
      5.225924,
      1,
      1,
      3,
      0,
      5.677689,
      1.314789,
      0,
      1,
      7.977027,
      1,
      NULL,
      3.948907,
      1.429404,
      1,
      NULL,
      NULL,
      3.103517,
      3,
      NULL,
      1,
      NULL,
      0.060362,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796887,
      1.350882,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0.399589,
      1,
      0.774825,
      1.406223,
      1.770679,
      0,
      1.864042,
      1,
      1,
      0.491090,
      0.075279,
      0.192949,
      1.354130,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      0.553924,
      4.782912,
      1.336267,
      NULL,
      1.220407,
      0,
      NULL,
      1,
      1.389414,
      5.542185,
      1.464474,
      4,
      0,
      1.122015,
      7.359861,
      6.556039,
      3.693531,
      4,
      2,
      1,
      1.294962,
      5.768799,
      NULL,
      3.392129,
      NULL,
      0.547338,
      0.474571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924744,
      1,
      NULL,
      0,
      1.402744,
      0.703536,
      0.745654,
      0.528998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.082796,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.967192,
      NULL,
      NULL,
      NULL,
      NULL,
      3.779239,
      3,
      3.544313,
      6,
      4.330159,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.096435,
      NULL,
      NULL,
      NULL,
      0,
      1.375442,
      2.256903,
      0.620704,
      1,
      NULL,
      1,
      2.995661,
      NULL,
      1.486409,
      3.553242,
      0,
      1.058349,
      0.915100,
      3.724655,
      3,
      1.774424,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1.234961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.044249,
      '24314',
      '',
      '',
      1,
      '',
      '',
      '',
      3.511497,
      '1323',
      '12204',
      '',
      NULL,
      0,
      2,
      NULL,
      2.649066,
      3.171833,
      2.452936,
      2.704448,
      1.611099);
commit;
end;
/


