set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44221343',
      NULL,
      NULL,
      '2301423',
      198,
      NULL,
      0,
      0,
      '404202',
      3.143975,
      '11-27-1992',
      NULL,
      29,
      0,
      NULL,
      0.647005,
      1.386397,
      1,
      NULL,
      1.409016,
      1,
      1,
      1,
      NULL,
      0,
      1.325052,
      NULL,
      1,
      0,
      0,
      NULL,
      3,
      1,
      0,
      1.302769,
      0.702293,
      NULL,
      3.109886,
      1,
      2,
      3,
      1,
      1.872647,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.885849,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.648402,
      1.201921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.660108,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1.361779,
      NULL,
      0,
      1.460173,
      1.213142,
      1.198921,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.984470,
      0.242459,
      1,
      3.145613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.451070,
      1.033519,
      1.325263,
      3,
      0.796579,
      2.941767,
      2,
      NULL,
      0,
      1.368690,
      6,
      NULL,
      5,
      2.309911,
      NULL,
      NULL,
      NULL,
      1,
      0.028492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253195,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0.761568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.467055,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.973831,
      0,
      1.231611,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.445738,
      4,
      0.885192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.659830,
      2.005939,
      NULL,
      NULL,
      1.941807,
      0,
      3.412834,
      0.485995,
      0,
      1.818371,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0.533625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '33214',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      2,
      '4322',
      '0201',
      '',
      3.843983,
      3,
      1,
      1.562084,
      1,
      2,
      1.907585,
      NULL,
      0.015834);
commit;
end;
/


