set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0340',
      '01124043',
      NULL,
      NULL,
      '4100042',
      142.753490,
      5,
      1,
      3,
      '033304',
      2.092921,
      NULL,
      13,
      4,
      NULL,
      NULL,
      1.762198,
      1.397153,
      3,
      NULL,
      0.185330,
      1,
      1,
      1,
      3.498364,
      0.349316,
      2.477195,
      1.180533,
      NULL,
      NULL,
      NULL,
      1.247324,
      3,
      NULL,
      1.978318,
      NULL,
      0.854670,
      NULL,
      NULL,
      1,
      2,
      2.334054,
      1.137329,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.599688,
      1,
      1,
      0.877678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932625,
      0.670593,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338565,
      0.764117,
      1,
      1.796221,
      1.255979,
      0,
      1,
      0,
      1.590536,
      0.393773,
      0.639694,
      0,
      1.138960,
      1.245418,
      0.154565,
      1.487887,
      NULL,
      0.947698,
      NULL,
      1,
      0.727047,
      0.116110,
      0.807497,
      0,
      1,
      1.741952,
      3.937819,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.821224,
      NULL,
      0.019885,
      7,
      7.268857,
      NULL,
      NULL,
      1,
      3.083884,
      0,
      2.273068,
      5,
      7.029808,
      1,
      0.603753,
      NULL,
      NULL,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608396,
      1,
      1,
      0.464238,
      1,
      1.066839,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115612,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149808,
      NULL,
      4,
      0.212786,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.873460,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186374,
      NULL,
      2,
      1.748238,
      0,
      1,
      2.479411,
      1.517923,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1.204078,
      1,
      1.165623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.926231,
      '41340',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3.984504,
      '2013',
      '2001',
      '',
      2.311587,
      NULL,
      2.227460,
      NULL,
      2,
      2.272734,
      1,
      NULL,
      3);
commit;
end;
/


